//
//  B5DatabaseObject.h
//  ApplicationFrameworks
//
//  Created by Rick Fillion on 2015-04-08.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordCore/OnePasswordCore.h>

/// B5DatabaseObject is a trimmed down OPDatabaseObject for the simplified B5 database.
/// Since B5DatabaseObjects will never see traditional sync, these objects shouldn't need a lot of the complexity inherent in OPDatabaseObject.
@interface B5DatabaseObject : NSObject <NSSecureCoding>

@property (nonatomic, readonly) OPID oid;
@property (nonatomic, readonly) BOOL hasOid;
@property (nonatomic, assign, readwrite) OPTimestamp updatedAt;
@property (nonatomic, assign, readwrite) OPTimestamp createdAt;

- (id)initNew;
- (id)initExistingWithID:(OPID)oid;

- (void)willSave;
- (void)didSave;

- (void)_setOid:(OPID)oid;

@end
